/*
  AUTOR: MICROSIDE TECHNOLOGY S.A. DE C.V.
  FECHA: JULIO 2022
  URLs:
  https://microside.com/
  https://microside.com/xide
  https://microside.com/docs/x-node-lte-gnss-sim7080g/

  ---------------------------------------------------------------------------
  Este ejemplo consiste en enviar datos de temperatura, humedad, luminosidad y
  proximidad a través de la red celular del X-NODE XC03.
  ---------------------------------------------------------------------------
*/

#include <XNODE.h>
XNODE xnode(&Serial2);

#define XC03 Serial2.println

/////////////////////////////////////////////////////////////
////////////////////   XC03 CONFIG   ////////////////////////
/////////////////////////////////////////////////////////////

#define CMD1 "AT"
#define CMD2 "AT+IPR=115200"
#define CMD3 "AT+SGPIO=0,5,1,1"
#define CMD4 "AT+COPS=0,2,\"334090\",7"
#define CMD5 "AT+CFUN=0"
#define CMD6 "AT+CGDCONT=1,\"IP\","
#define CMD7 "AT+CFUN=1"
#define CMD8 "AT+CLTS=1"
#define CMD9 "AT+CNACT=0,1"
#define CMD10 "AT+CFUN=1,1"



/////////////////////////////////////////////////////////////
////////////////////    HTTPS CONFIG   //////////////////////
/////////////////////////////////////////////////////////////

#define CHT1 "AT+CSSLCFG=\"sslversion\",1,3"
#define CHT2 "AT+SHSSL=1,\"\""
#define CHT3 "AT+SHCONF=\"URL\","
#define CHT4 "AT+SHCONF=\"BODYLEN\",1024"
#define CHT5 "AT+SHCONF=\"HEADERLEN\",350"
#define CHT6 "AT+SHDISC"
#define CHT7 "AT+SHCONN"
#define CHT8 "AT+SHREQ=\"/external/api/batch/update?token="
#define CHT9 "AT+SHSTATE?"

/////////////////////////////////////////////////////////////
////////////////////    CRITICAL DATA   /////////////////////
/////////////////////////////////////////////////////////////

#define APN "\"mobiledata\"" //APN para SIM multicarrier (898)
//#define APN "\"linksnet\"" //APN para SIM que no es multicarrier (894)
#define BLYNK_CLOUD "\"https://ny3.blynk.cloud:443\""
#define BLYNK_AUTH "FafxQwv-LMhgucmYlBsTRqaspG61q464"  //modifícalo de acuerdo con tu dispositivo en Blynk.

/////////////////////////////////////////////////////////////
////////////////////    HELPFUL DATA   //////////////////////
/////////////////////////////////////////////////////////////

#define POWERKEY 26
#define T 180000
String Data;
float HUM, TEMP, LUM;
int PROX;
String inputString = "";
bool stringComplete = false;
bool Control = false;
bool ERROR_ = false;
byte SEND_TIMES;
#define LED 4

/////////////////////////////////////////////////////////////
////////////////////     FUNCTIONS     //////////////////////
/////////////////////////////////////////////////////////////

//---------------------------------------------------------//
// En esta función se configura la conexión automática del //
// módulo, usando la configuración del APN y comandos AT.  //
//---------------------------------------------------------//

void XC03_begin()
{
  XC03(CMD1); XC01_DATA_read("OK\r\n", T);
  XC03(CMD2); XC01_DATA_read("OK\r\n", T);
  XC03(CMD3); XC01_DATA_read("OK\r\n", T);
  XC03(CMD4);  XC01_DATA_read("OK\r\n", T);
  XC03(CMD5);  XC01_DATA_read("OK\r\n", T);
  Data = String(CMD6) + String(APN);
  XC03(Data);  XC01_DATA_read("OK\r\n", T);
  XC03(CMD7);  XC01_DATA_read("SMS Ready\r\n", T); XC01_DATA_read("DST: 1\r\n", T); delay(1500);
  XC03(CMD8);  XC01_DATA_read("OK\r\n", T);
  XC03(CMD9);  XC01_DATA_read("+APP PDP: 0,ACTIVE\r\n", T); delay(1500);
}

//---------------------------------------------------------//
// En esta función se configura la conexión https a Blynk, //
// usando el token generado desde el dispositivo.          //
//---------------------------------------------------------//

void XC03_BLYNK_begin()
{
  XC03(CHT1); XC01_DATA_read("OK\r\n", T);
  XC03(CHT2); XC01_DATA_read("OK\r\n", T);
  Data = String(CHT3) + String(BLYNK_CLOUD);
  XC03(Data);  XC01_DATA_read("OK\r\n", T);
  XC03(CHT4); XC01_DATA_read("OK\r\n", T);
  XC03(CHT5); XC01_DATA_read("OK\r\n", T);
  XC03_CONN();
}

//---------------------------------------------------------//
// En esta función se establece la conexión https a Blynk. //
//---------------------------------------------------------//

void XC03_CONN()
{
  byte COUNTER = 0;
  bool FLAG1 = 0;

again:
  XC03(CHT7); XC01_DATA_read("OK\r\n", T);
  if (ERROR_)
  {
    FLAG1 = 1;
  }
  else {
    FLAG1 = 0;
  }
  if (ERROR_ && COUNTER <= 3)
  {
    delay(200);
    COUNTER++;
    goto again;
  }
  while (FLAG1) {
    Serial.println("Can't connect via https to cellular network..");
    delay(5000);

  }
}

//---------------------------------------------------------//
// Esta función pregunta el estado de la conexión a Blynk. //
//---------------------------------------------------------//

void CONNCETED()
{
again1:
  XC03(CHT9); XC01_DATA_read("+SHSTATE: 1\r\n", 4500);
  if (!stringComplete)
  {
    XC03(CHT9); XC01_DATA_read("+SHSTATE: 0\r\n", 4500);
    if (stringComplete)
    {
      XC03_BLYNK_begin();
      goto again1;
    }
  }


}

//---------------------------------------------------------//
//  Esta función envía los datos obtenidos a blynk.cloud.  //
//  Se debe tener en cuenta los pines virtuales para       //
//  poder hacer la correcta interpretación de los datos    //
//  que se van a visualizar en el dashboard de Blynk.      //
//---------------------------------------------------------//

void XC03_BLYNK_send(float A, float B, int C, float D)
{
  Serial.println("sending data over the cellular network..");
  Data = String(CHT8) + String(BLYNK_AUTH) + "&v0=" + String(A) + "&v1=" + String(B) + "&v2=" + String(C) + "&v3=" + String(D)   + "\",1";
  XC03(Data);  XC01_DATA_read("OK\r\n", 200);
  if (ERROR_)
  {

    XC03(CHT6); XC01_DATA_read("OK\r\n", T);
  }
  else
  {

    XC01_DATA_read("+SHREQ: \"GET\",200,0\r\n", 20000);
  }
}

//---------------------------------------------------------//
// Esta función se comunica con el XN04 para solicitar     //
// los valores de temperatura, humedad, proximidad y       //
// luminosidad para posteriormente guardarlos en las       //
// TEMP, HUM, LUM y PROX respectivamente.                  //
//---------------------------------------------------------//

void ReadSensor(void)
{
  Serial.println("----Reading Sensor Data----");

  TEMP = xnode.GetValueAsFloat("04A", "GT");
  Serial.printf("Temperatura= %.2f\n", TEMP);

  HUM = xnode.GetValueAsFloat("04A", "GH");
  Serial.printf("Humedad= %.2f\n", HUM);

  PROX = xnode.GetValueAsInt("04A", "GP");
  Serial.printf("Proximidad= %i\n", PROX);

  LUM = xnode.GetValueAsFloat("04A", "GL");
  Serial.printf("Luminosidad= %.2f\n", LUM);

  Serial.println(" ");
}

//---------------------------------------------------------//
// Esta función identifica la respuesta del módulo XC03,   //
// antes de enviar el siguiente comando, mientras ejecuta  //
// un timer para esperar la respuesta.                     //
//---------------------------------------------------------//

void XC01_DATA_read(String REQ, int times)
{
  digitalWrite(LED, LOW);
  stringComplete = false;
  Control = false;
  int timer0 = millis();
  inputString = "";
  char inChar;
  ERROR_ = false;

  while (!stringComplete)
  {
    char inChar;
    while (Serial2.available())
    {
      inChar = (char)Serial2.read();
      inputString += inChar;
      if (inputString == REQ) {
        digitalWrite(LED, HIGH);
        Serial.print(inputString);
        stringComplete = true;
      }
      if (inputString == "ERROR") {
        digitalWrite(LED, HIGH);
        Serial.println(inputString);
        ERROR_ = true;
        stringComplete = true;
      }
      if (inChar == '\n') {
        inputString = "";
      }

    }
    if (times == (millis() - timer0))
    {
      Serial.println("!No response from the module¡");
      Control = true;
      break;
    }
  }
}

//---------------------------------------------------------//
// Esta función eciende o resetea el modulo XC03.          //
//---------------------------------------------------------//

void XC03_INIT()
{
  XC03(CMD10);  XC01_DATA_read("OK\r\n", 1500);
  if (!stringComplete)
  {
    digitalWrite(LED, LOW);
    delay(500);
    digitalWrite(POWERKEY, HIGH);
    delay(1000);
    digitalWrite(POWERKEY, LOW);

  }
}

void setup() {

  //Se configuran las operaciones de XC01.//

  Serial.begin(115200);
  Serial2.begin(115200);
  pinMode(LED, OUTPUT);
  pinMode(POWERKEY, OUTPUT);
  digitalWrite(LED, LOW);
  /////////////////////////

  //Se envían las señales de inicio para encender el modem.//

  XC03_INIT();
  //////////////////////////

  //Se espera la respuesta de XC03.//

  XC01_DATA_read("SMS Ready\r\n", T);
  delay(4500);
  /////////////////////////

  //Se realiza la configuración y se establece la conexión.//

  XC03_begin();
  XC03_BLYNK_begin();
  ReadSensor();
  /////////////////////////
}

//Bucle infinito lectura-estado-envio.//

void loop() {
  ReadSensor();
  CONNCETED();
  XC03_BLYNK_send(TEMP, HUM, PROX, LUM);
  delay(5000);
}
